﻿using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;

namespace IpAndSockets
{
    class Program
    {
        static void Main(string[] args)
        {
            {
                // Listing 13-22. Pobieranie adresów IP związanych z nazwą hosta
                IPHostEntry hostDnsEntry = Dns.GetHostEntry("localhost");
                foreach (IPAddress address in hostDnsEntry.AddressList)
                {
                    Console.WriteLine("Typ: {0}, Adres: {1}", address.AddressFamily,
                        address);
                }
            }


            {
                // Listing 13-24. Korzystanie z obiektu Socket w celu pobrania danych z serwera udostępniającego informacje o czasie
                IPHostEntry hostDnsEntry = Dns.GetHostEntry("time-nw.nist.gov");
                IPAddress serverIp = hostDnsEntry.AddressList[0];

                Socket daytimeSocket = new Socket(
                    serverIp.AddressFamily,
                    SocketType.Stream,
                    ProtocolType.Tcp);
                daytimeSocket.Connect(serverIp, 13);
                string data;

                // Listing 13-23. Pobieranie danych ASCII z gniazda TCP
                using (Stream timeServiceStream = new NetworkStream(daytimeSocket, true))
                using (StreamReader timeServiceReader = new StreamReader(timeServiceStream,
                Encoding.ASCII))
                {
                    data = timeServiceReader.ReadToEnd();
                }

                Console.WriteLine(data);
            }
        }
    }
}
